import React, { Component } from 'react';
import {
  Box,
  Card,
  CardContent,
  Typography,
  Button,
  Tabs,
  Tab,
  Avatar,
  Grid,
  Divider,
  Paper,
  IconButton,
  Chip,
  TextField,
  Dialog,
  DialogTitle,
  DialogContent,
} from '@mui/material';
import {
  Edit,
  People,
  School,
  PersonAdd,
  Add,
  BookmarkBorder,
  Close,
  Visibility,
} from '@mui/icons-material';
import { AddStreamDialog } from './AddStreamDialog.jsx';

export class Profile extends Component {
  constructor(props) {
    super(props);
    
    this.state = {
      selectedTab: 0,
      addStreamDialogOpen: false,
      viewClassesDialogOpen: false,
      selectedStreamForViewing: null,
      streams: [
        { id: '1', name: 'Web Development', classIds: ['class_001', 'class_002', 'class_003', 'class_004', 'class_005', 'class_006'] },
        { id: '2', name: 'Mobile Apps', classIds: ['class_001', 'class_003'] },
        { id: '3', name: 'Data Science', classIds: ['class_002', 'class_005'] },
        { id: '4', name: 'UI/UX Design', classIds: ['class_001', 'class_002'] },
        { id: '5', name: 'Game Development', classIds: ['class_004'] },
        { id: '6', name: 'AI & Machine Learning', classIds: ['class_005'] },
        { id: '7', name: 'Cybersecurity', classIds: ['class_002', 'class_003'] },
        { id: '8', name: 'Cloud Computing', classIds: ['class_003', 'class_005'] },
      ],
      availableClasses: [],
      classesMap: {},
      isLoadingClasses: true,
    };
  }

  componentDidMount() {
    // Simulate loading classes from an API
    setTimeout(() => {
      const availableClasses = [
        { label: 'Beginner Level 1', class_id: 'class_001' },
        { label: 'Intermediate Level 2', class_id: 'class_002' },
        { label: 'Advanced Level 3', class_id: 'class_003' },
        { label: 'Advanced Level 4', class_id: 'class_004' },
        { label: 'Expert Level 5', class_id: 'class_005' },
        { label: 'Professional Level 6', class_id: 'class_006' },
      ];
      
      // Create a map for easy lookup of class names by ID
      const classesMap = {};
      availableClasses.forEach(classItem => {
        classesMap[classItem.class_id] = classItem.label;
      });
      
      this.setState({
        availableClasses,
        classesMap,
        isLoadingClasses: false,
      });
    }, 1500);
  }

  handleTabChange = (_event, newValue) => {
    this.setState({ selectedTab: newValue });
  };

  handleOpenAddStreamDialog = () => {
    this.setState({ addStreamDialogOpen: true });
  };

  handleCloseAddStreamDialog = () => {
    this.setState({ addStreamDialogOpen: false });
  };

  handleAddStream = (streamName, classIds) => {
    const newStream = {
      id: Date.now().toString(),
      name: streamName,
      classIds: classIds,
    };
    
    // Add new custom classes to classesMap and availableClasses if they don't exist
    classIds.forEach(classId => {
      if (!this.state.classesMap[classId]) {
        // This is a custom class
        const customClassOption = this.state.availableClasses.find(c => c.class_id === classId);
        if (customClassOption) {
          this.state.classesMap[classId] = customClassOption.label;
        }
      }
    });
    
    this.setState(prevState => ({
      streams: [...prevState.streams, newStream],
      addStreamDialogOpen: false,
    }));
  };

  handleOpenViewClassesDialog = (stream) => {
    this.setState({
      viewClassesDialogOpen: true,
      selectedStreamForViewing: stream,
    });
  };

  handleCloseViewClassesDialog = () => {
    this.setState({
      viewClassesDialogOpen: false,
      selectedStreamForViewing: null,
    });
  };

  render() {
    const { selectedTab, addStreamDialogOpen, viewClassesDialogOpen, selectedStreamForViewing, streams, availableClasses, classesMap, isLoadingClasses } = this.state;

    return (
      <Box sx={{ p: 4, backgroundColor: '#f8fafc', minHeight: '100vh' }}>
        <Typography variant="h4" sx={{ mb: 3, color: '#25476a', fontWeight: 600 }}>
          Profile
        </Typography>

        <Card sx={{ mb: 3, boxShadow: '0 2px 8px rgba(0,0,0,0.08)' }}>
          <Tabs
            value={selectedTab}
            onChange={this.handleTabChange}
            sx={{
              borderBottom: 1,
              borderColor: 'divider',
              px: 2,
              '& .MuiTab-root': {
                textTransform: 'none',
                fontSize: '0.95rem',
                fontWeight: 500,
                color: '#64748b',
              },
              '& .Mui-selected': {
                color: '#38aae1',
              },
              '& .MuiTabs-indicator': {
                backgroundColor: '#38aae1',
              },
            }}
          >
            <Tab label="Profile" />
            <Tab label="Time slots" />
            <Tab label="Billings" />
            <Tab label="Branches" />
          </Tabs>

          <CardContent sx={{ p: 3 }}>
            {selectedTab === 0 && (
              <Grid container spacing={3}>
                <Grid item xs={12} md={8}>
                  {/* Center Information */}
                  <Box sx={{ mb: 4 }}>
                    <Box sx={{ display: 'flex', alignItems: 'center', mb: 3 }}>
                      <Avatar
                        sx={{
                          width: 80,
                          height: 80,
                          backgroundColor: '#38aae1',
                          fontSize: '2rem',
                          fontWeight: 600,
                          mr: 3,
                        }}
                      >
                        TW
                      </Avatar>
                      <Box>
                        <Typography variant="h5" sx={{ color: '#25476a', fontWeight: 600, mb: 0.5 }}>
                          Thika west center
                        </Typography>
                        <Typography variant="body2" sx={{ color: '#64748b', mb: 1 }}>
                          Thika West Center
                        </Typography>
                        <Typography variant="body2" sx={{ color: '#64748b' }}>
                          0790252523
                        </Typography>
                        <Button
                          variant="outlined"
                          size="small"
                          startIcon={<Edit />}
                          sx={{
                            mt: 1,
                            textTransform: 'none',
                            borderColor: '#38aae1',
                            color: '#38aae1',
                            '&:hover': {
                              borderColor: '#2c8fc9',
                              backgroundColor: 'rgba(56, 170, 225, 0.04)',
                            },
                          }}
                        >
                          Edit
                        </Button>
                      </Box>
                    </Box>

                    {/* Stats Cards */}
                    <Grid container spacing={2} sx={{ mb: 4 }}>
                      <Grid item xs={12} sm={4}>
                        <Paper
                          sx={{
                            p: 2,
                            textAlign: 'center',
                            backgroundColor: '#f8fafc',
                            boxShadow: 'none',
                            border: '1px solid #e2e8f0',
                          }}
                        >
                          <People sx={{ fontSize: 40, color: '#38aae1', mb: 1 }} />
                          <Typography variant="h6" sx={{ color: '#25476a', fontWeight: 600 }}>
                            Mentors
                          </Typography>
                        </Paper>
                      </Grid>
                      <Grid item xs={12} sm={4}>
                        <Paper
                          sx={{
                            p: 2,
                            textAlign: 'center',
                            backgroundColor: '#f8fafc',
                            boxShadow: 'none',
                            border: '1px solid #e2e8f0',
                          }}
                        >
                          <School sx={{ fontSize: 40, color: '#38aae1', mb: 1 }} />
                          <Typography variant="h6" sx={{ color: '#25476a', fontWeight: 600 }}>
                            Classes
                          </Typography>
                        </Paper>
                      </Grid>
                      <Grid item xs={12} sm={4}>
                        <Paper
                          sx={{
                            p: 2,
                            textAlign: 'center',
                            backgroundColor: '#f8fafc',
                            boxShadow: 'none',
                            border: '1px solid #e2e8f0',
                          }}
                        >
                          <PersonAdd sx={{ fontSize: 40, color: '#38aae1', mb: 1 }} />
                          <Typography variant="h6" sx={{ color: '#25476a', fontWeight: 600 }}>
                            Learners
                          </Typography>
                        </Paper>
                      </Grid>
                    </Grid>
                  </Box>

                  {/* General Section */}
                  <Box sx={{ mb: 4 }}>
                    <Typography variant="h6" sx={{ color: '#25476a', fontWeight: 600, mb: 2 }}>
                      General
                    </Typography>
                    <Grid container spacing={2}>
                      <Grid item xs={6}>
                        <Typography variant="body2" sx={{ color: '#64748b', mb: 0.5 }}>
                          Registered date
                        </Typography>
                        <Typography variant="body1" sx={{ color: '#25476a', fontWeight: 500 }}>
                          20 September 2024
                        </Typography>
                      </Grid>
                      <Grid item xs={6}>
                        <Typography variant="body2" sx={{ color: '#64748b', mb: 0.5 }}>
                          Subscription plan
                        </Typography>
                        <Typography variant="body1" sx={{ color: '#25476a', fontWeight: 500 }}>
                          Kids Code Adventure
                        </Typography>
                      </Grid>
                      <Grid item xs={12}>
                        <Typography variant="body2" sx={{ color: '#64748b', mb: 0.5 }}>
                          User role
                        </Typography>
                        <Typography variant="body1" sx={{ color: '#25476a', fontWeight: 500 }}>
                          Center admin
                        </Typography>
                      </Grid>
                    </Grid>
                  </Box>

                  <Divider sx={{ my: 3 }} />

                  {/* Address Section */}
                  <Box>
                    <Typography variant="h6" sx={{ color: '#25476a', fontWeight: 600, mb: 2 }}>
                      Address
                    </Typography>
                    <Grid container spacing={2}>
                      <Grid item xs={12}>
                        <Typography variant="body2" sx={{ color: '#64748b', mb: 0.5 }}>
                          Located in
                        </Typography>
                      </Grid>
                      <Grid item xs={12}>
                        <Typography variant="body2" sx={{ color: '#64748b', mb: 0.5 }}>
                          Address
                        </Typography>
                      </Grid>
                      <Grid item xs={12}>
                        <Typography variant="body2" sx={{ color: '#64748b', mb: 0.5 }}>
                          Phone number
                        </Typography>
                        <Typography variant="body1" sx={{ color: '#25476a', fontWeight: 500 }}>
                          0790252523
                        </Typography>
                      </Grid>
                    </Grid>
                  </Box>
                </Grid>

                {/* Streams Section */}
                <Grid item xs={12} md={4}>
                  <Card
                    sx={{
                      backgroundColor: '#f8fafc',
                      boxShadow: 'none',
                      border: '1px solid #e2e8f0',
                    }}
                  >
                    <CardContent>
                      <Box
                        sx={{
                          backgroundColor: '#e2e8f0',
                          px: 2,
                          py: 1.5,
                          mb: 2,
                          borderRadius: 1,
                          textAlign: 'center',
                        }}
                      >
                        <Typography variant="body1" sx={{ color: '#25476a', fontWeight: 600 }}>
                          Member since September 2024
                        </Typography>
                      </Box>

                      <Box sx={{ display: 'flex', justifyContent: 'space-between', alignItems: 'center', mb: 2 }}>
                        <Typography variant="h6" sx={{ color: '#25476a', fontWeight: 600 }}>
                          Streams
                        </Typography>
                        <Chip
                          label={`${streams.length} total`}
                          size="small"
                          sx={{
                            backgroundColor: '#e2e8f0',
                            color: '#64748b',
                            fontWeight: 600,
                            height: '24px',
                          }}
                        />
                      </Box>

                      <Box sx={{ maxHeight: 350, overflow: 'auto', mb: 2 }}>
                        <Box
                          sx={{
                            display: 'grid',
                            gridTemplateColumns: 'repeat(2, 1fr)',
                            gap: 1.5,
                          }}
                        >
                          {streams.map((stream) => (
                            <Paper
                              key={stream.id}
                              elevation={0}
                              sx={{
                                p: 2,
                                backgroundColor: '#ffffff',
                                border: '2px solid #e2e8f0',
                                borderRadius: 2.5,
                                cursor: 'pointer',
                                transition: 'all 0.2s',
                                position: 'relative',
                                overflow: 'hidden',
                                '&:hover': {
                                  transform: 'translateY(-2px)',
                                  boxShadow: '0 6px 16px rgba(56, 170, 225, 0.15)',
                                  borderColor: '#38aae1',
                                  backgroundColor: '#f8fcff',
                                  '& .stream-icon': {
                                    backgroundColor: '#38aae1',
                                    color: '#ffffff',
                                  },
                                },
                                '&::before': {
                                  content: '""',
                                  position: 'absolute',
                                  top: 0,
                                  left: 0,
                                  right: 0,
                                  height: '4px',
                                  backgroundColor: '#38aae1',
                                  opacity: 0,
                                  transition: 'opacity 0.2s',
                                },
                                '&:hover::before': {
                                  opacity: 1,
                                },
                              }}
                              onClick={() => {
                                console.log('Stream clicked:', stream.name);
                              }}
                            >
                              <Box sx={{ display: 'flex', alignItems: 'center', gap: 1.5 }}>
                                <Box
                                  className="stream-icon"
                                  sx={{
                                    width: 36,
                                    height: 36,
                                    borderRadius: 2,
                                    backgroundColor: '#e3f2fd',
                                    color: '#38aae1',
                                    display: 'flex',
                                    alignItems: 'center',
                                    justifyContent: 'center',
                                    flexShrink: 0,
                                    transition: 'all 0.2s',
                                  }}
                                >
                                  <BookmarkBorder sx={{ fontSize: 20 }} />
                                </Box>
                                <Box sx={{ flex: 1, minWidth: 0 }}>
                                  <Typography
                                    variant="body2"
                                    sx={{
                                      color: '#25476a',
                                      fontWeight: 700,
                                      fontSize: '0.875rem',
                                      lineHeight: 1.3,
                                      mb: 0.5,
                                      overflow: 'hidden',
                                      textOverflow: 'ellipsis',
                                      display: '-webkit-box',
                                      WebkitLineClamp: 1,
                                      WebkitBoxOrient: 'vertical',
                                    }}
                                  >
                                    {stream.name}
                                  </Typography>
                                  <Box sx={{ display: 'flex', alignItems: 'center', gap: 0.5 }}>
                                    <School sx={{ fontSize: 14, color: '#64748b' }} />
                                    <Typography
                                      variant="caption"
                                      sx={{
                                        color: '#64748b',
                                        fontSize: '0.75rem',
                                        fontWeight: 600,
                                      }}
                                    >
                                      {stream.classes.length} {stream.classes.length === 1 ? 'Class' : 'Classes'}
                                    </Typography>
                                  </Box>
                                </Box>
                                <IconButton
                                  onClick={(e) => {
                                    e.stopPropagation();
                                    this.handleOpenViewClassesDialog(stream);
                                  }}
                                  sx={{
                                    width: 32,
                                    height: 32,
                                    backgroundColor: '#e3f2fd',
                                    color: '#38aae1',
                                    flexShrink: 0,
                                    '&:hover': {
                                      backgroundColor: '#38aae1',
                                      color: '#ffffff',
                                      transform: 'scale(1.05)',
                                    },
                                    transition: 'all 0.2s',
                                  }}
                                >
                                  <Visibility sx={{ fontSize: 18 }} />
                                </IconButton>
                              </Box>
                            </Paper>
                          ))}
                        </Box>
                      </Box>

                      <Button
                        fullWidth
                        startIcon={<Add />}
                        onClick={this.handleOpenAddStreamDialog}
                        sx={{
                          color: '#38aae1',
                          borderColor: '#38aae1',
                          borderWidth: '2px',
                          borderStyle: 'dashed',
                          borderRadius: 2,
                          py: 1.5,
                          textTransform: 'none',
                          fontWeight: 600,
                          '&:hover': {
                            borderColor: '#2c8fc9',
                            backgroundColor: '#f0f9ff',
                            borderWidth: '2px',
                            borderStyle: 'dashed',
                          },
                        }}
                      >
                        Add Stream
                      </Button>
                    </CardContent>
                  </Card>
                </Grid>
              </Grid>
            )}

            {selectedTab === 1 && (
              <Box>
                <Typography variant="body1" sx={{ color: '#64748b' }}>
                  Time slots content coming soon...
                </Typography>
              </Box>
            )}

            {selectedTab === 2 && (
              <Box>
                <Typography variant="body1" sx={{ color: '#64748b' }}>
                  Billings content coming soon...
                </Typography>
              </Box>
            )}

            {selectedTab === 3 && (
              <Box>
                <Typography variant="body1" sx={{ color: '#64748b' }}>
                  Branches content coming soon...
                </Typography>
              </Box>
            )}
          </CardContent>
        </Card>

        <AddStreamDialog
          open={addStreamDialogOpen}
          onClose={this.handleCloseAddStreamDialog}
          onAdd={this.handleAddStream}
          availableClasses={availableClasses}
          isLoadingClassOptions={isLoadingClasses}
        />

        <Dialog
          open={viewClassesDialogOpen}
          onClose={this.handleCloseViewClassesDialog}
          maxWidth="sm"
          fullWidth
          PaperProps={{
            sx: {
              borderRadius: 3,
              boxShadow: '0 8px 32px rgba(0, 0, 0, 0.12)',
            }
          }}
        >
          <DialogTitle
            sx={{
              backgroundColor: '#25476a',
              color: '#ffffff',
              py: 2.5,
              px: 3,
              display: 'flex',
              justifyContent: 'space-between',
              alignItems: 'center',
              fontWeight: 600,
            }}
          >
            {selectedStreamForViewing?.name} - All Classes
            <IconButton
              onClick={this.handleCloseViewClassesDialog}
              sx={{
                color: '#ffffff',
                '&:hover': {
                  backgroundColor: 'rgba(255, 255, 255, 0.1)',
                },
              }}
            >
              <Close />
            </IconButton>
          </DialogTitle>

          <DialogContent sx={{ px: 3, pt: 3, pb: 3 }}>
            <Box sx={{ display: 'flex', flexDirection: 'column', gap: 1.5 }}>
              <Box sx={{ display: 'flex', alignItems: 'center', gap: 1, mb: 1 }}>
                <School sx={{ fontSize: 18, color: '#38aae1' }} />
                <Typography variant="body2" sx={{ color: '#64748b', fontWeight: 600 }}>
                  {selectedStreamForViewing?.classes.length} Classes
                </Typography>
              </Box>
              {selectedStreamForViewing?.classes.map((className, idx) => {
                const colors = ['#25476a', '#feb139', '#38aae1'];
                const backgrounds = ['#dbeafe', '#fef3e2', '#e0f2fe'];
                const borders = ['#93c5fd', '#fed9a0', '#7dd3fc'];
                const colorIndex = idx % 3;
                
                return (
                  <Box
                    key={idx}
                    sx={{
                      display: 'flex',
                      alignItems: 'center',
                      gap: 2,
                      p: 2,
                      backgroundColor: '#f8fafc',
                      borderRadius: 2,
                      border: `2px solid #e2e8f0`,
                      transition: 'all 0.2s',
                      '&:hover': {
                        backgroundColor: backgrounds[colorIndex],
                        borderColor: colors[colorIndex],
                      },
                    }}
                  >
                    <Box
                      sx={{
                        width: 36,
                        height: 36,
                        borderRadius: 2,
                        backgroundColor: colors[colorIndex],
                        color: '#ffffff',
                        display: 'flex',
                        alignItems: 'center',
                        justifyContent: 'center',
                        fontWeight: 700,
                        fontSize: '0.875rem',
                      }}
                    >
                      {idx + 1}
                    </Box>
                    <Typography
                      variant="body1"
                      sx={{
                        color: '#25476a',
                        fontWeight: 600,
                        flex: 1,
                      }}
                    >
                      {className}
                    </Typography>
                  </Box>
                );
              })}
            </Box>
          </DialogContent>
        </Dialog>
      </Box>
    );
  }
}
