import { Session } from '../types';

export const createSessionsData = (completedSessions: Set<number>, currentSession: number): Session[] => [
  {
    id: 1,
    title: "Introduction to Pictoblox and Coding",
    description: "Let's begin...",
    status: completedSessions.has(1) ? 'completed' : 'available',
    isActive: currentSession === 1,
    price: 2000,
    duration: "2 hours",
    mentorAvailability: 'high'
  },
  {
    id: 2,
    title: "Sprites and Motion in Pictoblox",
    description: "Learn about sprites and basic motion",
    status: completedSessions.has(2) ? 'completed' : (completedSessions.has(1) ? 'available' : 'locked'),
    price: 2500,
    duration: "2.5 hours",
    mentorAvailability: 'high'
  },
  {
    id: 3,
    title: "Adding Motion to Sprites",
    description: "Make your sprites move with code",
    status: completedSessions.has(3) ? 'completed' : (completedSessions.has(2) ? 'available' : 'locked'),
    price: 2200,
    duration: "2.2 hours",
    mentorAvailability: 'medium'
  },
  {
    id: 4,
    title: "Types of Motion in Pictoblox",
    description: "Explore different motion types",
    status: completedSessions.has(4) ? 'completed' : (completedSessions.has(3) ? 'available' : 'locked'),
    price: 2800,
    duration: "2.8 hours",
    mentorAvailability: 'medium'
  },
  {
    id: 5,
    title: "Making Motion in Pictoblox",
    description: "Create complex motion patterns",
    status: completedSessions.has(5) ? 'completed' : (completedSessions.has(4) ? 'available' : 'locked'),
    price: 3000,
    duration: "3 hours",
    mentorAvailability: 'low'
  },
  {
    id: 6,
    title: "Creating a Sprite with a Background",
    description: "Design complete scenes",
    status: completedSessions.has(6) ? 'completed' : (completedSessions.has(5) ? 'available' : 'locked'),
    price: 2700,
    duration: "2.7 hours",
    mentorAvailability: 'medium'
  }
];

export const createProgressData = (completedSessions: Set<number>, totalSessions: number) => {
  const progress = Math.round((completedSessions.size / totalSessions) * 100);
  const timeCalculated = completedSessions.size === 0 ? "0h 0m" : 
    completedSessions.size === 1 ? "2h 15m" : 
    `${2 + (completedSessions.size - 1) * 2.4}h ${15 + (completedSessions.size - 1) * 20}m`;
  
  return {
    overallProgress: progress,
    timeSpent: timeCalculated,
    sessionsCompleted: completedSessions.size,
    totalSessions
  };
};

export const getDefaultVideoUrl = () => 
  "https://images.unsplash.com/photo-1663254743932-49190d0ee975?crop=entropy&cs=tinysrgb&fit=max&fm=jpg&ixid=M3w3Nzg4Nzd8MHwxfHNlYXJjaHwxfHxhbmltYXRlZCUyMGNhcnRvb24lMjBjaGFyYWN0ZXJ8ZW58MXx8fHwxNzU2NzI2NjAwfDA&ixlib=rb-4.1.0&q=80&w=1080&utm_source=figma&utm_medium=referral";