export type View = 'age-selection' | 'courses' | 'course-detail' | 'session-detail';

export interface Session {
  id: number;
  title: string;
  description: string;
  status: 'locked' | 'available' | 'completed';
  isActive?: boolean;
  price: number;
  duration: string;
  mentorAvailability: 'high' | 'medium' | 'low';
}

export interface CourseData {
  title: string;
  description: string;
  price: string;
  sessions: number;
  duration: string;
  students: string;
  image: string;
}

export interface ProgressData {
  overallProgress: number;
  timeSpent: string;
  sessionsCompleted: number;
  totalSessions: number;
}