// Type definitions for DigiFunzi platform
// These are used for documentation and development reference

/**
 * @typedef {'age-selection' | 'courses' | 'course-detail' | 'session-detail'} View
 */

/**
 * @typedef {Object} Session
 * @property {number} id
 * @property {string} title
 * @property {string} description
 * @property {'locked' | 'available' | 'completed'} status
 * @property {boolean} [isActive]
 * @property {number} price
 * @property {string} duration
 * @property {'high' | 'medium' | 'low'} mentorAvailability
 */

/**
 * @typedef {Object} CourseData
 * @property {string} title
 * @property {string} description
 * @property {string} price
 * @property {number} sessions
 * @property {string} duration
 * @property {string} students
 * @property {string} image
 */

/**
 * @typedef {Object} ProgressData
 * @property {number} overallProgress
 * @property {string} timeSpent
 * @property {number} sessionsCompleted
 * @property {number} totalSessions
 */

// Export empty object since this is just for type documentation
export {};