import { useState } from 'react';
import { useVideoTracking } from './useVideoTracking';

export const useSessionManagement = () => {
  const [currentView, setCurrentView] = useState('course-detail');
  const [currentSession, setCurrentSession] = useState(1);
  const [completedSessions, setCompletedSessions] = useState(new Set([]));
  const videoTracking = useVideoTracking();

  const handleStartCourse = () => {
    setCurrentView('session-detail');
    setCurrentSession(1);
    videoTracking.initializeSession(1);
  };

  const handleSessionClick = (sessionId) => {
    setCurrentSession(sessionId);
    setCurrentView('session-detail');
    videoTracking.initializeSession(sessionId);
  };

  const handleBackToCourse = () => {
    setCurrentView('course-detail');
  };

  const handlePreviousSession = () => {
    if (currentSession > 1) {
      setCurrentSession(currentSession - 1);
    }
  };

  const handleNextSession = (totalSessions) => {
    if (currentSession < totalSessions && completedSessions.has(currentSession)) {
      setCurrentSession(currentSession + 1);
    }
  };

  const handleSessionComplete = () => {
    const newCompleted = new Set(completedSessions);
    newCompleted.add(currentSession);
    setCompletedSessions(newCompleted);
  };

  const handleVideoProgress = (sessionId, videoId, progress) => {
    // Map video IDs to video types for the tracking system
    const videoTypeMap = {
      'introduction': 'courseVideo',
      'main-concepts': 'mainConcepts', 
      'activity-1': 'activity1',
      'assignment': 'assignment',
      'course-demo': 'courseVideo'
    };
    
    const videoType = videoTypeMap[videoId] || 'courseVideo';
    const duration = 300; // Default duration, this should be passed from video element
    const currentTime = (progress / 100) * duration;
    
    videoTracking.updateVideoProgress(sessionId, videoType, currentTime, duration);
  };

  return {
    currentView,
    currentSession,
    completedSessions,
    handleStartCourse,
    handleSessionClick,
    handleBackToCourse,
    handlePreviousSession,
    handleNextSession,
    handleSessionComplete,
    handleVideoProgress,
    videoTracking
  };
};