import { useState } from 'react';

export type AppView = 'courses' | 'course-detail' | 'session-detail';

export function useCourseNavigation() {
  const [currentView, setCurrentView] = useState<AppView>('courses');
  const [selectedCourseId, setSelectedCourseId] = useState<string | null>(null);

  const navigateToCourses = () => {
    setCurrentView('courses');
    setSelectedCourseId(null);
  };

  const navigateToCourseDetail = (courseId: string) => {
    setSelectedCourseId(courseId);
    setCurrentView('course-detail');
  };

  const navigateToSessionDetail = () => {
    setCurrentView('session-detail');
  };

  return {
    currentView,
    selectedCourseId,
    navigateToCourses,
    navigateToCourseDetail,
    navigateToSessionDetail,
  };
}