import { useState } from 'react';

export function useCourseNavigation() {
  const [currentView, setCurrentView] = useState('courses');
  const [selectedCourseId, setSelectedCourseId] = useState(null);

  const navigateToCourses = () => {
    setCurrentView('courses');
    setSelectedCourseId(null);
  };

  const navigateToCourseDetail = (courseId) => {
    setSelectedCourseId(courseId);
    setCurrentView('course-detail');
  };

  const navigateToSessionDetail = () => {
    setCurrentView('session-detail');
  };

  return {
    currentView,
    selectedCourseId,
    navigateToCourses,
    navigateToCourseDetail,
    navigateToSessionDetail,
  };
}