// Session data for different age-targeted courses

export const sessionDataMap = {
  'pictoblox-5-7': [
    {
      id: 1,
      title: "Meet PictoBlox - Your New Friend",
      description: "Discover the colorful world of coding with fun characters and simple movements",
      duration: "15 minutes",
      difficulty: 'Easy'
    },
    {
      id: 2,
      title: "Making Characters Move and Dance",
      description: "Learn to make sprites dance, jump, and move around the screen",
      duration: "18 minutes",
      difficulty: 'Easy'
    },
    {
      id: 3,
      title: "Colors and Sounds Adventure",
      description: "Add rainbow colors and funny sounds to your animations",
      duration: "20 minutes",
      difficulty: 'Easy'
    },
    {
      id: 4,
      title: "Story Time with Code",
      description: "Create your first interactive story with characters and dialogue",
      duration: "22 minutes",
      difficulty: 'Easy'
    },
    {
      id: 5,
      title: "Simple Games and Fun",
      description: "Build easy games like catch the ball and hide-and-seek",
      duration: "25 minutes",
      difficulty: 'Easy'
    },
    {
      id: 6,
      title: "My First Animation Movie",
      description: "Put everything together to create your own animated movie",
      duration: "30 minutes",
      difficulty: 'Easy'
    },
    {
      id: 7,
      title: "Sharing and Showing Off",
      description: "Learn to save and share your creations with family and friends",
      duration: "15 minutes",
      difficulty: 'Easy'
    },
    {
      id: 8,
      title: "What's Next? - Future Adventures",
      description: "Explore what you can learn next in your coding journey",
      duration: "20 minutes",
      difficulty: 'Easy'
    }
  ],
  'pictoblox-7-12': [
    {
      id: 1,
      title: "Introduction to PictoBlox and Programming Logic",
      description: "Understanding the interface and basic programming concepts",
      duration: "25 minutes",
      difficulty: 'Easy'
    },
    {
      id: 2,
      title: "Sprite Movement and Coordinate System",
      description: "Learn X-Y coordinates and precise sprite movements",
      duration: "30 minutes",
      difficulty: 'Easy'
    },
    {
      id: 3,
      title: "Loops and Repetition Patterns",
      description: "Master forever loops, repeat blocks, and creating patterns",
      duration: "35 minutes",
      difficulty: 'Medium'
    },
    {
      id: 4,
      title: "Conditional Statements and Decision Making",
      description: "If-then logic, sensing, and making sprites respond to conditions",
      duration: "40 minutes",
      difficulty: 'Medium'
    },
    {
      id: 5,
      title: "Variables and Score Keeping",
      description: "Creating variables, tracking scores, and data management",
      duration: "35 minutes",
      difficulty: 'Medium'
    },
    {
      id: 6,
      title: "Interactive Games - Part 1",
      description: "Building your first complete game with user controls",
      duration: "45 minutes",
      difficulty: 'Medium'
    },
    {
      id: 7,
      title: "Interactive Games - Part 2",
      description: "Adding levels, challenges, and game mechanics",
      duration: "50 minutes",
      difficulty: 'Medium'
    },
    {
      id: 8,
      title: "Sound Effects and Music Programming",
      description: "Creating soundtracks and sound effects for your projects",
      duration: "30 minutes",
      difficulty: 'Medium'
    },
    {
      id: 9,
      title: "Animation Techniques and Storytelling",
      description: "Advanced animation methods and narrative development",
      duration: "40 minutes",
      difficulty: 'Medium'
    },
    {
      id: 10,
      title: "Debugging and Problem Solving",
      description: "Finding and fixing errors, optimization techniques",
      duration: "35 minutes",
      difficulty: 'Medium'
    },
    {
      id: 11,
      title: "Final Project Development",
      description: "Plan and create your own unique game or animation",
      duration: "60 minutes",
      difficulty: 'Hard'
    },
    {
      id: 12,
      title: "Portfolio Creation and Sharing",
      description: "Documenting your work and preparing for next steps",
      duration: "30 minutes",
      difficulty: 'Easy'
    }
  ],
  'pictoblox-general': [
    {
      id: 1,
      title: "Introduction to PictoBlox and Coding Fundamentals",
      description: "Comprehensive overview of programming concepts and the PictoBlox environment",
      duration: "35 minutes",
      difficulty: 'Easy'
    },
    {
      id: 2,
      title: "Advanced Sprite Programming and Physics",
      description: "Complex movements, gravity simulation, and realistic physics",
      duration: "45 minutes",
      difficulty: 'Medium'
    },
    {
      id: 3,
      title: "Data Structures and Algorithm Basics",
      description: "Lists, arrays, sorting, and fundamental algorithm concepts",
      duration: "50 minutes",
      difficulty: 'Medium'
    },
    {
      id: 4,
      title: "Object-Oriented Programming Concepts",
      description: "Classes, objects, inheritance, and modular programming",
      duration: "55 minutes",
      difficulty: 'Hard'
    },
    {
      id: 5,
      title: "Advanced Game Development Patterns",
      description: "State machines, design patterns, and professional game structures",
      duration: "60 minutes",
      difficulty: 'Hard'
    },
    {
      id: 6,
      title: "AI and Machine Learning Basics",
      description: "Introduction to artificial intelligence concepts in visual programming",
      duration: "65 minutes",
      difficulty: 'Hard'
    },
    {
      id: 7,
      title: "IoT and Hardware Integration",
      description: "Connecting PictoBlox to sensors, Arduino, and real-world devices",
      duration: "70 minutes",
      difficulty: 'Hard'
    },
    {
      id: 8,
      title: "Web Technologies and API Integration",
      description: "Connecting to internet services and handling data from web APIs",
      duration: "60 minutes",
      difficulty: 'Hard'
    },
    {
      id: 9,
      title: "Advanced Animation and Graphics",
      description: "Complex visual effects, graphics programming, and rendering techniques",
      duration: "55 minutes",
      difficulty: 'Medium'
    },
    {
      id: 10,
      title: "Database Concepts and Data Management",
      description: "Storing, retrieving, and managing data in applications",
      duration: "50 minutes",
      difficulty: 'Medium'
    },
    {
      id: 11,
      title: "Software Engineering Principles",
      description: "Code organization, documentation, testing, and version control",
      duration: "60 minutes",
      difficulty: 'Hard'
    },
    {
      id: 12,
      title: "Performance Optimization and Best Practices",
      description: "Code efficiency, memory management, and optimization techniques",
      duration: "55 minutes",
      difficulty: 'Hard'
    },
    {
      id: 13,
      title: "Capstone Project - Part 1",
      description: "Planning and starting your comprehensive final project",
      duration: "90 minutes",
      difficulty: 'Hard'
    },
    {
      id: 14,
      title: "Capstone Project - Part 2",
      description: "Developing and refining your final project",
      duration: "90 minutes",
      difficulty: 'Hard'
    },
    {
      id: 15,
      title: "Professional Portfolio and Career Preparation",
      description: "Creating a professional portfolio and understanding career paths",
      duration: "45 minutes",
      difficulty: 'Medium'
    }
  ]
};

export const getSessionsByCourseId = (courseId) => {
  return sessionDataMap[courseId] || sessionDataMap['pictoblox-general'];
};