export interface Course {
  id: string;
  title: string;
  description: string;
  price: string;
  sessions: number;
  duration: string;
  students: string;
  image: string;
  ageRange: string;
  level: string;
  features: string[];
  color: string;
}

export const coursesData: Course[] = [
  {
    id: 'pictoblox-5-7',
    title: 'PictoBlox Adventures for Little Coders',
    description: 'A fun, colorful introduction to coding through games and storytelling. Perfect for young learners aged 5-7.',
    price: 'KES 2,500',
    sessions: 8,
    duration: '4 weeks',
    students: '2,150+',
    image: 'https://images.unsplash.com/photo-1675635408192-ff9b2ebe5023?crop=entropy&cs=tinysrgb&fit=max&fm=jpg&ixid=M3w3Nzg4Nzd8MHwxfHNlYXJjaHwxfHxraWRzJTIwY29kaW5nJTIwcHJvZ3JhbW1pbmclMjBjb2xvcmZ1bHxlbnwxfHx8fDE3NTY4MDQ3Nzh8MA&ixlib=rb-4.1.0&q=80&w=1080',
    ageRange: '5-7 years',
    level: 'Beginner',
    features: [
      'Interactive storytelling',
      'Colorful drag-and-drop coding',
      'Fun character animations',
      'Simple game creation',
      'Parent progress updates'
    ],
    color: 'from-pink-400 to-purple-500'
  },
  {
    id: 'pictoblox-7-12',
    title: 'PictoBlox Junior Developer Program',
    description: 'Build games, animations, and interactive projects while learning core programming concepts. Designed for ages 7-12.',
    price: 'KES 3,500',
    sessions: 12,
    duration: '6 weeks',
    students: '3,890+',
    image: 'https://images.unsplash.com/photo-1674049406486-4b1f6e1845fd?crop=entropy&cs=tinysrgb&fit=max&fm=jpg&ixid=M3w3Nzg4Nzd8MHwxfHNlYXJjaHwxfHxjaGlsZHJlbiUyMGxlYXJuaW5nJTIwY29tcHV0ZXIlMjB5b3VuZ3xlbnwxfHx8fDE3NTY4MDQ3ODJ8MA&ixlib=rb-4.1.0&q=80&w=1080',
    ageRange: '7-12 years',
    level: 'Beginner to Intermediate',
    features: [
      'Game development projects',
      'Logic and problem solving',
      'Creative animations',
      'Interactive storytelling',
      'Portfolio creation'
    ],
    color: 'from-blue-400 to-green-500'
  },
  {
    id: 'pictoblox-general',
    title: 'Complete PictoBlox Mastery Course',
    description: 'Master PictoBlox from basics to advanced concepts. Create games, animations, and learn fundamental programming principles.',
    price: 'KES 4,500',
    sessions: 15,
    duration: '8 weeks',
    students: '5,247+',
    image: 'https://images.unsplash.com/photo-1701967341617-14499d8bf8c3?crop=entropy&cs=tinysrgb&fit=max&fm=jpg&ixid=M3w3Nzg4Nzd8MHwxfHNlYXJjaHwxfHx0ZWVuYWdlcnMlMjBjb2RpbmclMjBwcm9ncmFtbWluZyUyMGxhcHRvcHxlbnwxfHx8fDE3NTY4MDQ3ODV8MA&ixlib=rb-4.1.0&q=80&w=1080',
    ageRange: '13+ years',
    level: 'All Levels',
    features: [
      'Complete curriculum coverage',
      'Advanced project development',
      'Industry best practices',
      'Technical mentor support',
      'Portfolio and certification'
    ],
    color: 'from-indigo-500 to-purple-600'
  }
];

export const getCourseById = (id: string): Course | undefined => {
  return coursesData.find(course => course.id === id);
};