// Course data for different age groups
export const courseDataMap = {
  'pictoblox-5-7': {
    title: "PictoBlox Adventures for Little Coders",
    description: "A fun, colorful introduction to coding through games and storytelling. Perfect for young learners aged 5-7. Learn basic programming concepts through interactive stories, simple animations, and creative play.",
    price: "2,500",
    sessions: 8,
    duration: "4 weeks",
    students: "2,150+ students",
    image: "https://app.digifunzi.com/videos/Lesson%201%2C%20Introduction%20%26%20Application%20%28Coding%20in%20Scratch%29.mp4"
  },
  'pictoblox-7-12': {
    title: "PictoBlox Junior Developer Program",
    description: "Build games, animations, and interactive projects while learning core programming concepts. Designed for ages 7-12. Create exciting games, learn logic and problem-solving, and develop your creativity through code.",
    price: "3,500",
    sessions: 12,
    duration: "6 weeks",
    students: "3,890+ students",
    image: "https://app.digifunzi.com/videos/Lesson%201%2C%20Introduction%20%26%20Application%20%28Coding%20in%20Scratch%29.mp4"
  },
  'pictoblox-general': {
    title: "Complete PictoBlox Mastery Course",
    description: "Master PictoBlox from basics to advanced concepts. Create games, animations, and learn fundamental programming principles. Perfect for students 13+ who want comprehensive coding education.",
    price: "4,500",
    sessions: 15,
    duration: "8 weeks",
    students: "5,247+ students",
    image: "https://app.digifunzi.com/videos/Lesson%201%2C%20Introduction%20%26%20Application%20%28Coding%20in%20Scratch%29.mp4"
  }
};

export const getCourseDataById = (courseId) => {
  return courseDataMap[courseId];
};