import { useState } from 'react';
import { motion } from 'motion/react';
import { ImageWithFallback } from './figma/ImageWithFallback';
import { SupportModal } from './SupportModal';
import { Trophy, Zap, HelpCircle, Settings, Star } from 'lucide-react';
import digifunziLogo from 'figma:asset/517ee9d784589cb130eb229f0ac854531acfb4ba.png';

export function Header7to12({ onAgeChange }) {
  const [showSupport, setShowSupport] = useState(false);

  return (
    <>
      <motion.header 
        initial={{ y: -20, opacity: 0 }}
        animate={{ y: 0, opacity: 1 }}
        className="bg-white shadow-xl border-b-4 border-blue-400"
      >
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-4">
          <div className="flex items-center justify-between">
            <div className="flex items-center space-x-4">
              <ImageWithFallback 
                src={digifunziLogo} 
                alt="DigiFunzi" 
                className="h-10 w-auto"
              />
              <div className="flex items-center space-x-2">
                <Zap className="h-6 w-6 text-orange-500" />
                <span className="text-2xl font-bold text-blue-600">
                  Young Developers
                </span>
              </div>
            </div>
            
            <div className="flex items-center space-x-4">
              <div className="flex items-center space-x-2 bg-yellow-100 px-4 py-2 rounded-full">
                <Star className="h-5 w-5 text-yellow-500" />
                <span className="font-semibold text-yellow-700">Level 3</span>
              </div>
              
              <div className="flex items-center space-x-2 bg-blue-100 px-4 py-2 rounded-full">
                <Trophy className="h-5 w-5 text-blue-500" />
                <span className="font-semibold text-blue-700">150 XP</span>
              </div>
              
              <motion.button
                whileHover={{ scale: 1.1 }}
                whileTap={{ scale: 0.9 }}
                onClick={() => setShowSupport(true)}
                className="p-3 bg-green-500 hover:bg-green-600 rounded-xl text-white shadow-lg transition-colors"
                title="Get Help"
              >
                <HelpCircle className="h-5 w-5" />
              </motion.button>
              
              <motion.button
                whileHover={{ scale: 1.1 }}
                whileTap={{ scale: 0.9 }}
                onClick={onAgeChange}
                className="p-3 bg-purple-500 hover:bg-purple-600 rounded-xl text-white shadow-lg transition-colors"
                title="Change Profile"
              >
                <Settings className="h-5 w-5" />
              </motion.button>
            </div>
          </div>
        </div>
      </motion.header>

      <SupportModal 
        isOpen={showSupport} 
        onClose={() => setShowSupport(false)} 
      />
    </>
  );
}