import { useState } from 'react';
import { motion } from 'motion/react';
import { ImageWithFallback } from './figma/ImageWithFallback';
import { SupportModal } from './SupportModal';
import { Sparkles, Home, HelpCircle, Settings } from 'lucide-react';
import digifunziLogo from 'figma:asset/517ee9d784589cb130eb229f0ac854531acfb4ba.png';

export function Header5to7({ onAgeChange = () => {} }) {
  const [showSupport, setShowSupport] = useState(false);

  return (
    <>
      <motion.header 
        initial={{ y: -20, opacity: 0 }}
        animate={{ y: 0, opacity: 1 }}
        className="bg-gradient-to-r from-pink-400 to-purple-500 shadow-lg border-b-4 border-yellow-300"
      >
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-4">
          <div className="flex items-center justify-between">
            <div className="flex items-center space-x-4">
              <ImageWithFallback 
                src={digifunziLogo} 
                alt="DigiFunzi" 
                className="h-10 w-auto"
              />
              <div className="flex items-center space-x-2">
                <Sparkles className="h-6 w-6 text-yellow-500" />
                <span className="text-2xl font-bold text-purple-600">
                  Little Coders
                </span>
              </div>
            </div>
            
            <div className="flex items-center space-x-3">
              <motion.button
                whileHover={{ scale: 1.1 }}
                whileTap={{ scale: 0.9 }}
                onClick={() => {}}
                className="p-3 bg-green-400 hover:bg-green-500 rounded-full text-white shadow-lg transition-colors"
                title="Home"
              >
                <Home className="h-5 w-5" />
              </motion.button>
              
              <motion.button
                whileHover={{ scale: 1.1 }}
                whileTap={{ scale: 0.9 }}
                onClick={() => setShowSupport(true)}
                className="p-3 bg-blue-400 hover:bg-blue-500 rounded-full text-white shadow-lg transition-colors"
                title="Get Help"
              >
                <HelpCircle className="h-5 w-5" />
              </motion.button>
              
              <motion.button
                whileHover={{ scale: 1.1 }}
                whileTap={{ scale: 0.9 }}
                onClick={onAgeChange}
                className="p-3 bg-purple-400 hover:bg-purple-500 rounded-full text-white shadow-lg transition-colors"
                title="Change Age"
              >
                <Settings className="h-5 w-5" />
              </motion.button>
            </div>
          </div>
        </div>
      </motion.header>

      <SupportModal 
        isOpen={showSupport} 
        onClose={() => setShowSupport(false)} 
      />
    </>
  );
}