import { Button } from "./ui/button";
import { Search, Bell, User } from "lucide-react";
import { ImageWithFallback } from './figma/ImageWithFallback';
import digiFunziLogo from 'figma:asset/517ee9d784589cb130eb229f0ac854531acfb4ba.png';

export function Header() {
  return (
    <header className="bg-gradient-to-r from-indigo-600 via-purple-600 to-blue-700 border-b border-purple-200 shadow-lg">
      <div className="max-w-7xl mx-auto px-4">
        <div className="flex items-center justify-between h-18">
          <div className="flex items-center gap-8">
            <div className="flex items-center gap-3">
              <ImageWithFallback 
                src={digiFunziLogo} 
                alt="DigiFunzi Logo" 
                className="w-10 h-10 rounded-lg shadow-sm"
              />
              <div className="flex flex-col">
                <span className="text-2xl font-bold text-white">DigiFunzi</span>
                <span className="text-xs text-purple-100">Quest Academy (13+ years)</span>
              </div>
            </div>
            
            <nav className="hidden lg:flex items-center gap-8">
              <div className="text-purple-200 border-b-2 border-white pb-1">
                <span className="text-sm font-medium">Advanced Coding Projects</span>
              </div>
            </nav>
          </div>

          <div className="flex items-center gap-4">
            <div className="hidden md:flex items-center gap-2 bg-white/10 backdrop-blur-sm rounded-lg px-4 py-2 border border-white/20">
              <Search className="w-4 h-4 text-white/80" />
              <input 
                type="text" 
                placeholder="Search advanced courses..." 
                className="bg-transparent border-none outline-none text-sm w-52 text-white placeholder-white/60"
              />
            </div>
            
            <Button variant="ghost" size="sm" className="text-white hover:bg-white/10 hover:text-white">
              <Bell className="w-4 h-4" />
            </Button>
            
            <div className="flex items-center gap-2">
              <Button variant="ghost" size="sm" className="text-white hover:bg-white/10 hover:text-white">
                <User className="w-4 h-4" />
              </Button>
              <div className="hidden md:block">
                <div className="text-xs text-purple-100">Quest Level</div>
                <div className="text-sm font-medium text-white">Advanced Coder</div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </header>
  );
}