import { Card, CardContent } from "./ui/card";
import { Badge } from "./ui/badge";
import { BookOpen, Award, Clock } from "lucide-react";

interface CourseInfoItem {
  icon: React.ReactNode;
  title: string;
  description: string;
}

export function CourseInfo() {
  const courseIncludes: CourseInfoItem[] = [
    {
      icon: <BookOpen className="w-5 h-5" />,
      title: "12 Sessions",
      description: "Interactive lessons"
    },
    {
      icon: <Award className="w-5 h-5" />,
      title: "48 Topics",
      description: "Comprehensive coverage"
    },
    {
      icon: <Award className="w-5 h-5" />,
      title: "Course Certificate",
      description: "Upon completion"
    }
  ];

  const learningTopics = [
    "X and Y positioning",
    "Debugging",
    "Developing a Story Island",
    "Intermediate coding in Scratch",
    "Logical thinking",
    "Collaboration and Presentation"
  ];

  return (
    <div className="max-w-7xl mx-auto px-4 py-8">
      <div className="grid lg:grid-cols-2 gap-8">
        {/* Course Includes */}
        <div className="space-y-6">
          <h2 className="text-2xl">Course Includes</h2>
          <div className="space-y-4">
            {courseIncludes.map((item, index) => (
              <div key={index} className="flex items-start gap-3">
                <div className="text-blue-600 mt-1">
                  {item.icon}
                </div>
                <div>
                  <div className="font-medium">{item.title}</div>
                  <div className="text-sm text-muted-foreground">{item.description}</div>
                </div>
              </div>
            ))}
          </div>
        </div>

        {/* What You'll Learn */}
        <div className="space-y-6">
          <h2 className="text-2xl">What You'll Learn</h2>
          <div className="grid grid-cols-1 gap-3">
            {learningTopics.map((topic, index) => (
              <div key={index} className="flex items-center gap-3">
                <div className="w-2 h-2 bg-blue-600 rounded-full flex-shrink-0"></div>
                <span className="text-sm">{topic}</span>
              </div>
            ))}
          </div>
        </div>
      </div>
    </div>
  );
}