import { useState } from 'react';
import { motion } from 'motion/react';
import { ImageWithFallback } from './figma/ImageWithFallback';
import digifunziLogo from 'figma:asset/517ee9d784589cb130eb229f0ac854531acfb4ba.png';

export function AgeSelection({ onAgeSelect, selectedAge: externalSelectedAge }) {
  const [selectedAge, setSelectedAge] = useState(externalSelectedAge || null);

  const ageGroups = [
    {
      id: '5-7',
      title: '5-7 Years',
      subtitle: 'Little Coders',
      description: 'Fun and colorful learning with simple coding concepts',
      icon: '🌈',
      colors: 'from-pink-200 to-yellow-200',
      hoverColors: 'from-pink-300 to-yellow-300'
    },
    {
      id: '7-12',
      title: '7-12 Years',
      subtitle: 'Young Developers',
      description: 'Game-like learning with achievements and challenges',
      icon: '🎮',
      colors: 'from-blue-200 to-green-200',
      hoverColors: 'from-blue-300 to-green-300'
    },
    {
      id: '13+',
      title: '13+ Years',
      subtitle: 'Advanced Learners',
      description: 'Comprehensive coding education with advanced concepts',
      icon: '💻',
      colors: 'from-purple-200 to-gray-200',
      hoverColors: 'from-purple-300 to-gray-300'
    }
  ];

  return (
    <div className="w-full">
      <div className="max-w-2xl w-full mx-auto">
        <div className="text-center mb-6">
          <h3 className="text-lg font-semibold text-gray-800 mb-2">
            Choose Your Age Group
          </h3>
          <p className="text-sm text-gray-600">
            We'll recommend the perfect course for you
          </p>
        </div>

        <div className="grid grid-cols-1 gap-3 mb-6">
          {ageGroups.map((group, index) => (
            <div
              key={group.id}
              className={`
                bg-gradient-to-r ${group.colors} hover:bg-gradient-to-r hover:${group.hoverColors}
                rounded-lg p-4 cursor-pointer transition-all duration-200
                border-2 ${selectedAge === group.id ? 'border-blue-500 shadow-md' : 'border-transparent'}
                hover:shadow-md
              `}
              onClick={() => {
                setSelectedAge(group.id);
                onAgeSelect(group.id);
              }}
            >
              <div className="flex items-center gap-4">
                <div className="text-2xl">{group.icon}</div>
                <div className="flex-1">
                  <h3 className="font-semibold text-gray-800">
                    {group.title} - {group.subtitle}
                  </h3>
                  <p className="text-sm text-gray-600">
                    {group.description}
                  </p>
                </div>
              </div>
            </div>
          ))}
        </div>

      </div>
    </div>
  );
}