import * as React from "react";

function cn(...classes) {
  return classes.filter(Boolean).join(" ");
}

const Slider = React.forwardRef(({ 
  className, 
  value = [0], 
  onValueChange, 
  max = 100, 
  min = 0, 
  step = 1, 
  ...props 
}, ref) => {
  const handleChange = (event) => {
    const newValue = Number(event.target.value);
    onValueChange?.([newValue]);
  };

  return (
    <div className={cn("relative flex w-full touch-none select-none items-center", className)}>
      <input
        ref={ref}
        type="range"
        min={min}
        max={max}
        step={step}
        value={value[0]}
        onChange={handleChange}
        className="relative h-2 w-full cursor-pointer appearance-none rounded-full bg-secondary outline-none slider-thumb:appearance-none slider-thumb:h-4 slider-thumb:w-4 slider-thumb:rounded-full slider-thumb:bg-primary slider-thumb:cursor-pointer"
        {...props}
      />
    </div>
  );
});
Slider.displayName = "Slider";

export { Slider };