import { useState } from "react";

export function ImageWithFallback({ src, alt, className, fallback, ...props }) {
  const [imgError, setImgError] = useState(false);
  const [imgLoading, setImgLoading] = useState(true);

  const handleImageError = () => {
    setImgError(true);
    setImgLoading(false);
  };

  const handleImageLoad = () => {
    setImgLoading(false);
  };

  if (imgError) {
    return (
      <div className={`bg-gray-200 flex items-center justify-center ${className}`} {...props}>
        {fallback || (
          <div className="text-gray-400 text-center">
            <svg className="w-8 h-8 mx-auto mb-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
              <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z" />
            </svg>
            <span className="text-xs">Image not found</span>
          </div>
        )}
      </div>
    );
  }

  return (
    <>
      {imgLoading && (
        <div className={`bg-gray-200 animate-pulse ${className}`} {...props} />
      )}
      <img
        src={src}
        alt={alt}
        className={`${className} ${imgLoading ? 'hidden' : ''}`}
        onError={handleImageError}
        onLoad={handleImageLoad}
        {...props}
      />
    </>
  );
}