import { GraduationCap, FolderOpen, Settings, User, Home, CreditCard } from "lucide-react";
import companyLogo from "figma:asset/517ee9d784589cb130eb229f0ac854531acfb4ba.png";

export function Sidebar({ activeSection, onSectionChange, selectedClass }) {
  // Age-appropriate navigation labels
  const getMenuItems = () => {
    switch (selectedClass) {
      case "crib":
        return [
          { id: "dashboard", label: "🏠 Magic Home", icon: Home },
          { id: "classes", label: "✨ My Adventures", icon: GraduationCap },
          { id: "projects", label: "🎨 My Creations", icon: FolderOpen },
          { id: "billing", label: "💰 Parent Zone", icon: CreditCard },
          { id: "profile", label: "⭐ My Stars", icon: User },
          { id: "settings", label: "🎵 Fun Settings", icon: Settings },
        ];
      case "clicker":
        return [
          { id: "dashboard", label: "🎮 Mission Control", icon: Home },
          { id: "classes", label: "🚀 Tech Academy", icon: GraduationCap },
          { id: "projects", label: "🏆 My Projects", icon: FolderOpen },
          { id: "billing", label: "💳 Payments", icon: CreditCard },
          { id: "profile", label: "👤 My Profile", icon: User },
          { id: "settings", label: "⚙️ Settings", icon: Settings },
        ];
      case "quest":
        return [
          { id: "dashboard", label: "Dashboard", icon: Home },
          { id: "classes", label: "Courses", icon: GraduationCap },
          { id: "projects", label: "Portfolio", icon: FolderOpen },
          { id: "billing", label: "Billing & Plans", icon: CreditCard },
          { id: "profile", label: "Profile", icon: User },
          { id: "settings", label: "Preferences", icon: Settings },
        ];
      default:
        return [
          { id: "dashboard", label: "Dashboard", icon: Home },
          { id: "classes", label: "Classes", icon: GraduationCap },
          { id: "projects", label: "Projects", icon: FolderOpen },
          { id: "billing", label: "Billing", icon: CreditCard },
          { id: "profile", label: "Profile", icon: User },
          { id: "settings", label: "Settings", icon: Settings },
        ];
    }
  };

  const menuItems = getMenuItems();

  // Age-appropriate theming with distinct color schemes
  const getClassTheme = () => {
    switch (selectedClass) {
      case "crib":
        // Crib: Light Blue primary, Yellow secondary, Navy accent
        return {
          background: "bg-gradient-to-b from-light-blue via-light-blue/80 to-navy/40",
          border: "border-yellow/30",
          active: "bg-yellow text-navy border border-yellow shadow-md",
          inactive: "text-navy/80 hover:bg-yellow/25 hover:text-navy",
          userBg: "bg-gradient-to-br from-light-blue to-yellow",
          userIcon: "text-navy",
          className: "Crib Adventures",
          level: "Explorer Level",
          emoji: "🎨",
          accentCircles: (
            <>
              <div className="absolute top-0 right-0 w-32 h-32 bg-yellow/20 rounded-full -mr-16 -mt-16"></div>
              <div className="absolute bottom-20 left-0 w-20 h-20 bg-yellow/15 rounded-full -ml-10"></div>
              <div className="absolute top-1/3 left-0 w-16 h-16 bg-navy/10 rounded-full -ml-8"></div>
            </>
          )
        };
      case "clicker":
        // Clicker: Navy primary, Light Blue secondary, Yellow accent
        return {
          background: "bg-gradient-to-b from-navy via-navy/90 to-light-blue/50",
          border: "border-light-blue/30",
          active: "bg-light-blue/30 text-white border border-light-blue/50 shadow-md",
          inactive: "text-white/90 hover:bg-light-blue/20 hover:text-white",
          userBg: "bg-gradient-to-br from-navy to-light-blue",
          userIcon: "text-white",
          className: "Clicker Academy",
          level: "Builder Level",
          emoji: "🎮",
          accentCircles: (
            <>
              <div className="absolute bottom-0 left-0 w-24 h-24 bg-light-blue/15 rounded-full -ml-12 -mb-12"></div>
              <div className="absolute top-1/3 right-0 w-16 h-16 bg-yellow/10 rounded-full -mr-8"></div>
              <div className="absolute top-0 left-1/4 w-12 h-12 bg-yellow/8 rounded-full"></div>
            </>
          )
        };
      case "quest":
        // Quest: Navy primary, Light Blue secondary, Yellow minimal accent
        return {
          background: "bg-gradient-to-b from-navy via-navy/95 to-light-blue/40",
          border: "border-light-blue/25",
          active: "bg-light-blue/25 text-white border border-light-blue/40 shadow-md",
          inactive: "text-white/90 hover:bg-light-blue/15 hover:text-white",
          userBg: "bg-gradient-to-br from-navy to-light-blue",
          userIcon: "text-white",
          className: "Quest Mastery",
          level: "Developer Level",
          emoji: "🚀",
          accentCircles: (
            <>
              <div className="absolute top-1/2 right-0 w-20 h-40 bg-light-blue/8 rounded-l-full -mr-10"></div>
              <div className="absolute bottom-1/4 left-0 w-16 h-16 bg-yellow/5 rounded-full -ml-8"></div>
            </>
          )
        };
      default:
        return {
          background: "bg-gradient-to-b from-light-blue via-navy to-navy",
          border: "border-navy/20",
          active: "bg-light-blue text-white",
          inactive: "text-white/80 hover:bg-white/10",
          userBg: "bg-light-blue",
          userIcon: "text-white",
          className: "DigiFunzi",
          level: "Student",
          emoji: "💡",
          accentCircles: null
        };
    }
  };

  const theme = getClassTheme();

  return (
    <div className={`w-64 ${theme.background} h-screen flex flex-col relative overflow-hidden`}>
      {/* Age-specific background accents */}
      {theme.accentCircles}
      {/* Logo and Class Identity */}
      <div className={`p-6 border-b ${theme.border} relative z-10`}>
        <img 
          src={companyLogo} 
          alt="DigiFunzi Logo" 
          className="h-8 w-auto mb-3"
        />
        {selectedClass && (
          <div className="text-white/90">
            <div className="flex items-center gap-2 text-sm">
              <span className="text-lg">{theme.emoji}</span>
              <span className="font-medium">{theme.className}</span>
            </div>
          </div>
        )}
      </div>

      {/* Navigation */}
      <nav className="flex-1 p-4 relative z-10">
        <ul className="space-y-2">
          {menuItems.map((item) => {
            const Icon = item.icon;
            return (
              <li key={item.id}>
                <button
                  onClick={() => onSectionChange(item.id)}
                  className={`w-full flex items-center gap-3 px-4 py-3 rounded-lg transition-all duration-300 ${
                    activeSection === item.id
                      ? theme.active
                      : theme.inactive
                  }`}
                >
                  <Icon size={20} />
                  <span className="font-medium">{item.label}</span>
                </button>
              </li>
            );
          })}
        </ul>
      </nav>

      {/* User Profile */}
      <div className="p-4 border-t border-white/10 relative z-10">
        <div className="flex items-center gap-3 text-white/90">
          <div className={`w-10 h-10 ${theme.userBg} rounded-full flex items-center justify-center shadow-lg transition-transform duration-300 hover:scale-105`}>
            <User size={18} className={theme.userIcon} />
          </div>
          <div>
            <p className="text-sm font-medium">Student Name</p>
            <p className="text-xs text-white/70">{theme.level}</p>
            {selectedClass && (
              <div className="text-xs text-white/60 mt-1">
                {selectedClass === "crib" && "Ages 5-7"}
                {selectedClass === "clicker" && "Ages 8-12"}
                {selectedClass === "quest" && "Ages 13+"}
              </div>
            )}
          </div>
        </div>
      </div>
    </div>
  );
}