import { ArrowLeft, Home, Shield, Award, Briefcase, Code2, Users, TrendingUp } from "lucide-react";
import { Button } from "./ui/button";
import { Badge } from "./ui/badge";

interface QuestNavbarProps {
  currentCourse?: string;
  onBackToClasses?: () => void;
  onNavigateToDashboard?: () => void;
  onHelp?: () => void;
  onContactUs?: () => void;
}

export function QuestNavbar({ 
  currentCourse, 
  onBackToClasses,
  onNavigateToDashboard,
  onHelp,
  onContactUs 
}: QuestNavbarProps) {

  return (
    <div className="bg-navy text-white">
      {/* Top Navigation Bar - Professional for teens */}
      <div className="flex items-center justify-between px-6 py-4 border-b border-white/10">
        <div className="flex items-center gap-4">
          <div className="flex items-center gap-3">
            <span className="text-xl font-bold">digifunzi</span>
            <div className="flex items-center gap-2 bg-white/10 rounded-md px-3 py-1.5 border border-white/20">
              <Shield className="w-5 h-5 text-yellow" fill="currentColor" />
              <span className="font-semibold">Quest Program</span>
            </div>
          </div>
        </div>

        <div className="flex items-center gap-3">
          {/* Professional Achievement Level */}
          <Badge className="bg-gradient-to-r from-yellow to-orange-400 text-navy px-3 py-1.5 font-semibold">
            <Award className="w-4 h-4 mr-1" />
            Advanced Developer
          </Badge>
          
          {/* Portfolio Points */}
          <Badge className="bg-white/10 border border-white/20 text-white px-3 py-1.5">
            <TrendingUp className="w-4 h-4 mr-1" />
            2,850 Portfolio Points
          </Badge>
          
          {/* Professional Skills Indicators */}
          <div className="flex items-center gap-2">
            <div className="w-10 h-10 bg-gradient-to-br from-green-600 to-emerald-700 rounded-md flex items-center justify-center text-white shadow-lg border border-green-500/30">
              <Code2 className="w-5 h-5" />
            </div>
            <div className="w-10 h-10 bg-gradient-to-br from-blue-600 to-indigo-700 rounded-md flex items-center justify-center text-white shadow-lg border border-blue-500/30">
              <Briefcase className="w-5 h-5" />
            </div>
            <div className="w-10 h-10 bg-gradient-to-br from-purple-600 to-violet-700 rounded-md flex items-center justify-center text-white shadow-lg border border-purple-500/30">
              <Users className="w-5 h-5" />
            </div>
          </div>
          
          <Button
            variant="ghost"
            size="sm"
            onClick={onHelp}
            className="text-white hover:bg-white/10 border border-white/20 rounded-md px-4"
          >
            <Shield className="w-4 h-4 mr-1" />
            Technical Support
          </Button>
          
          <Button
            variant="ghost"
            size="sm"
            onClick={onContactUs}
            className="text-white hover:bg-white/10 border border-white/20 rounded-md px-4"
          >
            <Users className="w-4 h-4 mr-1" />
            Industry Mentors
          </Button>
        </div>
      </div>

      {/* Professional Breadcrumb Navigation */}
      <div className="bg-white border-b border-gray-200 px-6 py-4">
        <div className="flex items-center justify-between">
          <div className="flex items-center gap-3 text-sm">
            <button 
              onClick={onBackToClasses}
              className="flex items-center gap-2 text-navy hover:text-navy/80 transition-colors bg-navy/5 rounded-md px-3 py-2 border border-navy/10"
            >
              <ArrowLeft className="w-4 h-4" />
              <span className="font-medium">Back to Programs</span>
            </button>
            
            <div className="h-4 w-px bg-gray-300"></div>
            
            <button 
              onClick={onNavigateToDashboard}
              className="flex items-center gap-2 hover:text-navy transition-colors text-gray-600 bg-gray-50 rounded-md px-3 py-2"
            >
              <Home className="w-4 h-4" />
              <span className="font-medium">DigiFunzi Platform</span>
            </button>
            
            <span className="text-gray-400">/</span>
            
            <div className="flex items-center gap-2 bg-navy/5 rounded-md px-3 py-2 border border-navy/10">
              <Shield className="w-4 h-4 text-navy" fill="currentColor" />
              <span className="font-semibold text-navy">Quest Program</span>
            </div>
            
            {currentCourse && (
              <>
                <span className="text-gray-400">/</span>
                <div className="bg-gradient-to-r from-navy/5 to-indigo-50 rounded-md px-3 py-2 border border-navy/15">
                  <span className="text-navy font-semibold">{currentCourse}</span>
                </div>
              </>
            )}
          </div>
          
          {/* Right side professional indicators */}
          <div className="flex items-center gap-3">
            <Badge className="bg-gradient-to-r from-yellow to-orange-400 text-navy font-semibold">
              <Award className="w-3 h-3 mr-1" />
              Advanced
            </Badge>
            <Badge className="bg-navy/10 border border-navy/20 text-navy">
              <TrendingUp className="w-3 h-3 mr-1" />
              2,850 Points
            </Badge>
            
            {/* Professional certifications indicators */}
            <div className="flex items-center gap-1">
              <div className="w-6 h-6 bg-gradient-to-br from-green-600 to-emerald-700 rounded-sm flex items-center justify-center text-white text-xs font-bold">
                P
              </div>
              <div className="w-6 h-6 bg-gradient-to-br from-blue-600 to-indigo-700 rounded-sm flex items-center justify-center text-white text-xs font-bold">
                W
              </div>
              <div className="w-6 h-6 bg-gradient-to-br from-purple-600 to-violet-700 rounded-sm flex items-center justify-center text-white text-xs font-bold">
                A
              </div>
            </div>
            
            {/* Career readiness indicator */}
            <div className="flex items-center gap-1 text-xs text-gray-600 bg-gray-100 rounded-md px-2 py-1">
              <div className="w-2 h-2 bg-green-500 rounded-full"></div>
              <span>Career Ready</span>
            </div>
          </div>
        </div>
      </div>
    </div>
  );
}