import { ArrowLeft, Home, Heart, Star, Gift, Sparkles } from "lucide-react";
import { Button } from "./ui/button";
import { Badge } from "./ui/badge";

interface CribNavbarProps {
  currentCourse?: string;
  onBackToClasses?: () => void;
  onNavigateToDashboard?: () => void;
  onHelp?: () => void;
  onContactUs?: () => void;
}

export function CribNavbar({ 
  currentCourse, 
  onBackToClasses,
  onNavigateToDashboard,
  onHelp,
  onContactUs 
}: CribNavbarProps) {

  return (
    <div className="bg-gradient-to-r from-yellow via-light-blue to-navy text-white">
      {/* Top Navigation Bar - More colorful and fun for kids */}
      <div className="flex items-center justify-between px-6 py-4 border-b border-white/20">
        <div className="flex items-center gap-4">
          <div className="flex items-center gap-3">
            <span className="text-xl font-bold">✨ digifunzi</span>
            <div className="flex items-center gap-2 bg-white/20 rounded-full px-3 py-1">
              <Heart className="w-5 h-5 text-white" fill="currentColor" />
              <span className="font-semibold">Magic Learning Zone</span>
            </div>
          </div>
        </div>

        <div className="flex items-center gap-3">
          {/* Fun level badge for kids */}
          <Badge className="bg-gradient-to-r from-green-400 to-green-500 text-white text-sm px-3 py-1">
            🌟 Super Star Level 3
          </Badge>
          
          {/* XP badge */}
          <Badge className="bg-gradient-to-r from-purple-400 to-purple-500 text-white text-sm px-3 py-1">
            ⚡ 180 Magic Points
          </Badge>
          
          {/* Collectible badges - bigger and more colorful for kids */}
          <div className="flex items-center gap-2">
            <div className="w-10 h-10 bg-gradient-to-r from-green-400 to-green-500 rounded-full flex items-center justify-center text-white font-bold text-lg shadow-lg">
              🎯
            </div>
            <div className="w-10 h-10 bg-gradient-to-r from-yellow to-orange-400 rounded-full flex items-center justify-center text-white font-bold text-lg shadow-lg">
              🏆
            </div>
            <div className="w-10 h-10 bg-gradient-to-r from-pink-400 to-pink-500 rounded-full flex items-center justify-center text-white font-bold text-lg shadow-lg">
              🎨
            </div>
          </div>
          
          <Button
            variant="ghost"
            size="sm"
            onClick={onHelp}
            className="text-white hover:bg-white/20 border border-white/30 rounded-full px-4"
          >
            <Gift className="w-4 h-4 mr-1" />
            Get Help
          </Button>
          
          <Button
            variant="ghost"
            size="sm"
            onClick={onContactUs}
            className="text-white hover:bg-white/20 border border-white/30 rounded-full px-4"
          >
            <Sparkles className="w-4 h-4 mr-1" />
            Ask Teacher
          </Button>
        </div>
      </div>

      {/* Kid-friendly Breadcrumb Navigation */}
      <div className="bg-white border-b border-gray-200 px-6 py-4">
        <div className="flex items-center justify-between">
          <div className="flex items-center gap-3 text-sm">
            <button 
              onClick={onBackToClasses}
              className="flex items-center gap-2 text-light-blue hover:text-light-blue/80 transition-colors bg-light-blue/10 rounded-full px-3 py-2"
            >
              <ArrowLeft className="w-4 h-4" />
              <span className="font-medium">🏠 Back to My Classes</span>
            </button>
            
            <div className="flex items-center gap-2 text-gray-500">
              <Star className="w-4 h-4" fill="currentColor" />
              <Star className="w-4 h-4" fill="currentColor" />
              <Star className="w-4 h-4" fill="currentColor" />
            </div>
            
            <button 
              onClick={onNavigateToDashboard}
              className="flex items-center gap-2 hover:text-light-blue transition-colors bg-gray-50 rounded-full px-3 py-2"
            >
              <Home className="w-4 h-4" />
              <span className="font-medium">✨ digifunzi</span>
            </button>
            
            <div className="flex items-center gap-2 text-gray-500">
              <div className="w-2 h-2 bg-yellow rounded-full"></div>
              <div className="w-2 h-2 bg-light-blue rounded-full"></div>
              <div className="w-2 h-2 bg-pink-400 rounded-full"></div>
            </div>
            
            <div className="flex items-center gap-2 bg-white/20 rounded-full px-3 py-2">
              <Heart className="w-4 h-4 text-white" fill="currentColor" />
              <span className="font-semibold text-white">Magic Learning Zone</span>
            </div>
            
            {currentCourse && (
              <>
                <div className="flex items-center gap-1 text-gray-400">
                  <div className="w-1 h-1 bg-current rounded-full"></div>
                  <div className="w-1 h-1 bg-current rounded-full"></div>
                  <div className="w-1 h-1 bg-current rounded-full"></div>
                </div>
                <div className="bg-gradient-to-r from-purple-100 to-pink-100 rounded-full px-3 py-2">
                  <span className="text-purple-700 font-semibold">🎮 {currentCourse}</span>
                </div>
              </>
            )}
          </div>
          
          {/* Right side badges - simplified for kids */}
          <div className="flex items-center gap-3">
            <Badge className="bg-gradient-to-r from-green-400 to-green-500 text-white">
              🌟 Level 3
            </Badge>
            <Badge className="bg-gradient-to-r from-purple-400 to-purple-500 text-white">
              ⚡ 180 Points
            </Badge>
            <div className="flex items-center gap-1">
              <div className="w-8 h-8 bg-gradient-to-r from-green-400 to-green-500 rounded-full flex items-center justify-center text-white font-bold">
                🎯
              </div>
              <div className="w-8 h-8 bg-gradient-to-r from-yellow to-orange-400 rounded-full flex items-center justify-center text-white font-bold">
                🏆
              </div>
              <div className="w-8 h-8 bg-gradient-to-r from-pink-400 to-pink-500 rounded-full flex items-center justify-center text-white font-bold">
                🎨
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  );
}