import { Button } from "./ui/button";
import { Badge } from "./ui/badge";
import { ArrowLeft, Home, HelpCircle, MessageCircle, Heart } from "lucide-react";
import companyLogo from "figma:asset/517ee9d784589cb130eb229f0ac854531acfb4ba.png";

export function CribNavbar({ 
  currentCourse, 
  onBackToClasses, 
  onNavigateToDashboard, 
  onHelp, 
  onContactUs 
}) {
  return (
    <nav className="bg-gradient-to-r from-yellow via-light-blue to-navy text-white p-4 shadow-lg">
      <div className="flex items-center justify-between">
        <div className="flex items-center gap-4">
          <img 
            src={companyLogo} 
            alt="DigiFunzi" 
            className="h-8 w-auto"
          />
          
          <div className="flex items-center gap-3">
            <Button
              variant="ghost"
              size="sm"
              onClick={onBackToClasses}
              className="text-white hover:bg-white/20"
            >
              <ArrowLeft size={16} className="mr-1" />
              🌟 Back to Magic Classes
            </Button>
            
            <div className="text-sm">
              <Badge variant="outline" className="text-white border-white/30 bg-white/10">
                <Heart size={12} className="mr-1" fill="currentColor" />
                CRIB MAGIC
              </Badge>
              <span className="ml-2">{currentCourse}</span>
            </div>
          </div>
        </div>

        <div className="flex items-center gap-2">
          <Button
            variant="ghost"
            size="sm"
            onClick={onNavigateToDashboard}
            className="text-white hover:bg-white/20"
          >
            <Home size={16} className="mr-1" />
            🏠 My Dashboard
          </Button>
          
          <Button
            variant="ghost"
            size="sm"
            onClick={onHelp}
            className="text-white hover:bg-white/20"
          >
            <HelpCircle size={16} className="mr-1" />
            🎈 Get Help
          </Button>
          
          <Button
            variant="ghost"
            size="sm"
            onClick={onContactUs}
            className="text-white hover:bg-white/20"
          >
            <MessageCircle size={16} className="mr-1" />
            💬 Talk to Friends
          </Button>
        </div>
      </div>
    </nav>
  );
}