import { ArrowLeft, Home, Lightbulb, Zap, Trophy, Target, Code, Gamepad2 } from "lucide-react";
import { Button } from "./ui/button";
import { Badge } from "./ui/badge";

interface ClickerNavbarProps {
  currentCourse?: string;
  onBackToClasses?: () => void;
  onNavigateToDashboard?: () => void;
  onHelp?: () => void;
  onContactUs?: () => void;
}

export function ClickerNavbar({ 
  currentCourse, 
  onBackToClasses,
  onNavigateToDashboard,
  onHelp,
  onContactUs 
}: ClickerNavbarProps) {

  return (
    <div className="bg-gradient-to-r from-light-blue to-navy text-white">
      {/* Top Navigation Bar - Tech-focused for tweens */}
      <div className="flex items-center justify-between px-6 py-4 border-b border-light-blue/20">
        <div className="flex items-center gap-4">
          <div className="flex items-center gap-3">
            <span className="text-xl font-bold">⚡ digifunzi</span>
            <div className="flex items-center gap-2 bg-white/20 rounded-lg px-3 py-1.5">
              <Lightbulb className="w-5 h-5 text-yellow" fill="currentColor" />
              <span className="font-semibold">Clicker Academy</span>
            </div>
          </div>
        </div>

        <div className="flex items-center gap-3">
          {/* Achievement Level */}
          <Badge className="bg-gradient-to-r from-yellow to-orange-500 text-white px-3 py-1.5">
            <Trophy className="w-4 h-4 mr-1" />
            Code Master Lv.3
          </Badge>
          
          {/* XP Points */}
          <Badge className="bg-gradient-to-r from-purple-500 to-indigo-600 text-white px-3 py-1.5">
            <Zap className="w-4 h-4 mr-1" />
            1,250 XP
          </Badge>
          
          {/* Skill Badges - Tech themed */}
          <div className="flex items-center gap-2">
            <div className="w-10 h-10 bg-gradient-to-r from-green-500 to-emerald-600 rounded-lg flex items-center justify-center text-white shadow-lg border-2 border-white/20">
              <Code className="w-5 h-5" />
            </div>
            <div className="w-10 h-10 bg-gradient-to-r from-orange-500 to-red-500 rounded-lg flex items-center justify-center text-white shadow-lg border-2 border-white/20">
              <Gamepad2 className="w-5 h-5" />
            </div>
            <div className="w-10 h-10 bg-gradient-to-r from-purple-500 to-pink-500 rounded-lg flex items-center justify-center text-white shadow-lg border-2 border-white/20">
              <Target className="w-5 h-5" />
            </div>
          </div>
          
          <Button
            variant="ghost"
            size="sm"
            onClick={onHelp}
            className="text-white hover:bg-white/20 border border-white/30 rounded-lg px-4"
          >
            <Lightbulb className="w-4 h-4 mr-1" />
            Get Help
          </Button>
          
          <Button
            variant="ghost"
            size="sm"
            onClick={onContactUs}
            className="text-white hover:bg-white/20 border border-white/30 rounded-lg px-4"
          >
            <Zap className="w-4 h-4 mr-1" />
            Ask Mentor
          </Button>
        </div>
      </div>

      {/* Tech-focused Breadcrumb Navigation */}
      <div className="bg-white border-b border-gray-200 px-6 py-4">
        <div className="flex items-center justify-between">
          <div className="flex items-center gap-3 text-sm">
            <button 
              onClick={onBackToClasses}
              className="flex items-center gap-2 text-light-blue hover:text-light-blue/80 transition-colors bg-light-blue/10 rounded-lg px-3 py-2 border border-light-blue/20"
            >
              <ArrowLeft className="w-4 h-4" />
              <span className="font-medium">← My Classes</span>
            </button>
            
            <div className="flex items-center gap-1 text-gray-400">
              <div className="w-1 h-1 bg-current rounded-full"></div>
              <div className="w-2 h-2 bg-current rounded-full"></div>
              <div className="w-1 h-1 bg-current rounded-full"></div>
            </div>
            
            <button 
              onClick={onNavigateToDashboard}
              className="flex items-center gap-2 hover:text-light-blue transition-colors bg-gray-50 rounded-lg px-3 py-2"
            >
              <Home className="w-4 h-4" />
              <span className="font-medium">DigiFunzi</span>
            </button>
            
            <span className="text-gray-400">→</span>
            
            <div className="flex items-center gap-2 bg-gradient-to-r from-light-blue/10 to-navy/10 rounded-lg px-3 py-2 border border-light-blue/20">
              <Lightbulb className="w-4 h-4 text-light-blue" fill="currentColor" />
              <span className="font-semibold text-gray-700">Clicker Class</span>
            </div>
            
            {currentCourse && (
              <>
                <span className="text-gray-400">→</span>
                <div className="bg-gradient-to-r from-indigo-50 to-purple-50 rounded-lg px-3 py-2 border border-indigo-200">
                  <span className="text-indigo-700 font-semibold">{currentCourse}</span>
                </div>
              </>
            )}
          </div>
          
          {/* Right side progress indicators */}
          <div className="flex items-center gap-3">
            <Badge className="bg-gradient-to-r from-yellow to-orange-500 text-white">
              <Trophy className="w-3 h-3 mr-1" />
              Level 3
            </Badge>
            <Badge className="bg-gradient-to-r from-purple-500 to-indigo-600 text-white">
              <Zap className="w-3 h-3 mr-1" />
              1,250 XP
            </Badge>
            
            {/* Mini skill indicators */}
            <div className="flex items-center gap-1">
              <div className="w-6 h-6 bg-gradient-to-r from-green-500 to-emerald-600 rounded flex items-center justify-center text-white text-xs font-bold">
                C
              </div>
              <div className="w-6 h-6 bg-gradient-to-r from-orange-500 to-red-500 rounded flex items-center justify-center text-white text-xs font-bold">
                G
              </div>
              <div className="w-6 h-6 bg-gradient-to-r from-purple-500 to-pink-500 rounded flex items-center justify-center text-white text-xs font-bold">
                P
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  );
}