import { Button } from "./ui/button";
import { Badge } from "./ui/badge";
import { ArrowLeft, Home, HelpCircle, MessageCircle } from "lucide-react";
import companyLogo from "figma:asset/517ee9d784589cb130eb229f0ac854531acfb4ba.png";

export function ClassNavbar({ 
  classType, 
  currentCourse, 
  onBackToClasses, 
  onNavigateToDashboard, 
  onHelp, 
  onContactUs 
}) {
  const getThemeClasses = () => {
    switch (classType) {
      case "crib":
        return {
          bg: "gradient-crib-navbar",
          text: "text-white"
        };
      case "clicker":
        return {
          bg: "gradient-clicker-navbar",
          text: "text-white"
        };
      case "quest":
        return {
          bg: "gradient-quest-navbar",
          text: "text-white"
        };
      default:
        return {
          bg: "bg-gray-800",
          text: "text-white"
        };
    }
  };

  const theme = getThemeClasses();

  return (
    <nav className={`${theme.bg} ${theme.text} p-4 shadow-lg`}>
      <div className="flex items-center justify-between">
        <div className="flex items-center gap-4">
          <img 
            src={companyLogo} 
            alt="DigiFunzi" 
            className="h-8 w-auto"
          />
          
          <div className="flex items-center gap-3">
            <Button
              variant="ghost"
              size="sm"
              onClick={onBackToClasses}
              className="text-white hover:bg-white/20"
            >
              <ArrowLeft size={16} className="mr-1" />
              Back to Classes
            </Button>
            
            <div className="text-sm">
              <Badge variant="outline" className="text-white border-white/30 bg-white/10">
                {classType?.toUpperCase() || "COURSE"}
              </Badge>
              <span className="ml-2">{currentCourse}</span>
            </div>
          </div>
        </div>

        <div className="flex items-center gap-2">
          <Button
            variant="ghost"
            size="sm"
            onClick={onNavigateToDashboard}
            className="text-white hover:bg-white/20"
          >
            <Home size={16} className="mr-1" />
            Dashboard
          </Button>
          
          <Button
            variant="ghost"
            size="sm"
            onClick={onHelp}
            className="text-white hover:bg-white/20"
          >
            <HelpCircle size={16} className="mr-1" />
            Help
          </Button>
          
          <Button
            variant="ghost"
            size="sm"
            onClick={onContactUs}
            className="text-white hover:bg-white/20"
          >
            <MessageCircle size={16} className="mr-1" />
            Support
          </Button>
        </div>
      </div>
    </nav>
  );
}